<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="Strings.xsl"/>
	<xsl:output method="html" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="UTF-8" indent="yes"/>		
	
	<!-- Template for generating the main report. The main entry point for the transformation. -->
	<xsl:template name="Summary" match="FMPReport">
		<html>
			<head>
				<title>
					<xsl:value-of select="$valDatabaseDesignReport"/>
				</title>
				<link href="{$valReportCSS}" type="text/css" rel="stylesheet"/>		
			</head>	
			<body>
				<p>
					<span class="maintitle">
						<xsl:value-of select="$valDatabaseDesignReport"/>
					</span>
					<br/>
					<span class="chartheadersnobg">
						<xsl:value-of select="concat($valReportCreated,': ',@creationDate,' ',$valAtTime,' ',@creationTime)"/>
					</span>
				</p>
				<p class="partheading">
					<xsl:value-of select="$valReportOverview"/>
				</p>
				<table borderColor="#cccccc" width="100%" border="1">
					<tbody>
						<tr class="chartheaders" vAlign="top">
							<td width="14%">
								<div align="center">
									<xsl:value-of select="$valFileName"/>
								</div>
							</td>
							<td width="5%">
								<div align="center">
									<xsl:value-of select="$valTables"/>
								</div>
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valRelationships"/>
								</div>
							</td>
							<td width="6%">
								<div align="center">
									<xsl:value-of select="$valLayouts"/>
								</div>
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valValueLists"/>
								</div>
							</td>
							<td width="4%">
								<div align="center">
									<xsl:value-of select="$valScripts"/>
								</div>
							</td>
							<td width="7%">
								<div align="center">
									<xsl:value-of select="$valAccounts"/>
								</div>
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valPrivilegeSets"/>
								</div>
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valExtendedPrivileges"/>
								</div>			
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valCustomFunctions"/>
								</div>
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valDataSources"/>
								</div>
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valCustomMenuSets"/>
								</div>
							</td>
							<td width="8%">
								<div align="center">
									<xsl:value-of select="$valCustomMenus"/>
								</div>
							</td>
						</tr>
						<xsl:for-each select="File">
							<xsl:sort select="@name"/>
							<tr class="regularcharttext">								
								<td>
									<div align="center">	
										<xsl:call-template name="ExternalLink-NoAnchor">
											<xsl:with-param name="inFileLink" select="@link"/>
											<xsl:with-param name="inDisplayText" select="@name"/>
										</xsl:call-template>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
										<xsl:when test="BaseTables/@count &gt; 0">
											<xsl:call-template name="ExternalLink-NoAnchor">
												<xsl:with-param name="inFileLink" select="concat(@link,'?','valTables', $kAnchorSection)"/>
												<xsl:with-param name="inDisplayText" select="BaseTables/@count"/>
											</xsl:call-template>											
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="BaseTables/@count"/>
										</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="Relationships/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valRelationships',$kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="Relationships/@count"/>
												</xsl:call-template>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="Relationships/@count"/>
											</xsl:otherwise>
										</xsl:choose>
											
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="Layouts/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valLayouts',$kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="Layouts/@count"/>
												</xsl:call-template>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="Layouts/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="ValueLists/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valValueLists',$kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="ValueLists/@count"/>
												</xsl:call-template>													
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="ValueLists/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="Scripts/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valScripts',$kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="Scripts/@count"/>
												</xsl:call-template>																								
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="Scripts/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="Accounts/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valAccounts', $kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="Accounts/@count"/>
												</xsl:call-template>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="Accounts/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="Privileges/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valPrivilegeSets', $kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="Privileges/@count"/>
												</xsl:call-template>													
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="Privileges/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="ExtendedPrivileges/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link, '?', 'valExtendedPrivileges', $kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="ExtendedPrivileges/@count"/>
												</xsl:call-template>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="ExtendedPrivileges/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="CustomFunctions/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valCustomFunctions',$kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="CustomFunctions/@count"/>
												</xsl:call-template>														
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="CustomFunctions/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="FileReferences/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valFileReferences', $kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="FileReferences/@count"/>
												</xsl:call-template>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="FileReferences/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="CustomMenuSets/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valCustomMenuSets', $kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="CustomMenuSets/@count"/>
												</xsl:call-template>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="CustomMenuSets/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
								<td>
									<div align="center">
										<xsl:choose>
											<xsl:when test="CustomMenus/@count &gt; 0">
												<xsl:call-template name="ExternalLink-NoAnchor">
													<xsl:with-param name="inFileLink" select="concat(@link,'?','valCustomMenus', $kAnchorSection)"/>
													<xsl:with-param name="inDisplayText" select="CustomMenus/@count"/>
												</xsl:call-template>												
											</xsl:when>
											<xsl:otherwise>
												<xsl:value-of select="CustomMenus/@count"/>
											</xsl:otherwise>
										</xsl:choose>
									</div>
								</td>
							</tr>						
						</xsl:for-each>
					</tbody>
				</table>
			</body>
		</html>
	</xsl:template>
</xsl:stylesheet>